<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              xmlns:wwmultisere="urn:WebWorks-XSLT-Extension-MultiSearchReplace"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwvars wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc wwmultisere"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterProjectVariablesType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />
 <xsl:preserve-space elements="html:script" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />


 <xsl:include href="wwtransform:common/variables/variables.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwformat:Transforms/connect_utilities.xsl" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/variables/variables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/variables/variables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Page template include files -->
 <!--                             -->
 <xsl:variable name="GlobalPageTemplateIncludeFilesAsXML">
  <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-include-files">
   <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
  </xsl:apply-templates>
 </xsl:variable>
 <xsl:variable name="GlobalPageTemplateIncludeFiles" select="msxsl:node-set($GlobalPageTemplateIncludeFilesAsXML)" />


 <!-- Project variables -->
 <!--                   -->
 <xsl:variable name="GlobalProjectVariablesPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectVariablesType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectVariables" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectVariablesPath)" />


 <xsl:variable name="GlobalFilenameSpacesToUnderscores" select="wwprojext:GetFormatSetting('filename-spaces-to-underscores') = 'true'" />
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresSearchString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text> </xsl:text>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresReplaceString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text>_</xsl:text>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="GlobalInvalidPathCharactersExpression" select="'[#&amp;?]'" />

 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Get page template files -->
   <!--                         -->
   <xsl:variable name="VarPageTemplateFilesAsXML">
    <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-files" />
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFiles" select="msxsl:node-set($VarPageTemplateFilesAsXML)" />
   <xsl:variable name="VarPageTemplateFilesPaths">
    <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
     <xsl:value-of select="@path" />
     <xsl:value-of select="':'" />
    </xsl:for-each>
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFilesChecksum" select="wwstring:MD5Checksum($VarPageTemplateFilesPaths)" />

   <!-- Search Page -->
   <!--             -->
   <xsl:variable name="VarProgressSearchStart" select="wwprogress:Start(1)" />

   <!-- Aborted? -->
   <!--          -->
   <xsl:if test="not(wwprogress:Abort())">
    <!-- Create search page -->
    <!--                    -->
    <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), 'connect', 'search.html')" />
    <xsl:call-template name="Search">
     <xsl:with-param name="ParamPath" select="$VarPath" />
     <xsl:with-param name="ParamVariables" select="$GlobalProjectVariables//wwvars:Variable" />
     <xsl:with-param name="ParamPageTemplateFiles" select="$VarPageTemplateFiles" />
     <xsl:with-param name="ParamPageTemplateFilesChecksum" select="$VarPageTemplateFilesChecksum" />
    </xsl:call-template>
   </xsl:if>

   <xsl:variable name="VarProgressSearchEnd" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Search">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamVariables" />
  <xsl:param name="ParamPageTemplateFiles" />
  <xsl:param name="ParamPageTemplateFilesChecksum" />

  <!-- Determine output directory path -->
  <!--                                 -->
  <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:GetDirectoryName($ParamPath)" />

  <!-- Output -->
  <!--        -->
  <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($ParamPath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', $ParamPageTemplateFilesChecksum), '', '', $GlobalActionChecksum)" />
  <xsl:if test="not($VarUpToDate)">
   <xsl:variable name="VarResultAsXML">
    <!-- Conditions -->
    <!--            -->
    <xsl:variable name="VarConditionsAsXML">
     <!-- Google Analytics -->
     <!--                  -->
     <xsl:if test="string-length(wwprojext:GetFormatSetting('google-analytics-id')) &gt; 0">
      <wwpage:Condition name="google-analytics-enabled" />
     </xsl:if>
    </xsl:variable>
    <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

    <!-- Replacements -->
    <!--              -->
    <xsl:variable name="VarReplacementsAsXML">
     <!-- Locale -->
     <!--        -->
     <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />

     <!-- Content Type -->
     <!--              -->
     <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

     <!-- Title -->
     <!--       -->
     <wwpage:Replacement name="title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'SearchTabLabel']/@value}" />

     <wwpage:Replacement name="google-analytics">
      <xsl:text>var _gaq = _gaq || [];
_gaq.push(['_setAccount', '</xsl:text>
      <xsl:value-of select="wwprojext:GetFormatSetting('google-analytics-id')" />
     <xsl:text>']);
_gaq.push(['_trackPageview']);

(function() {
  var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
  ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
  var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
})();</xsl:text>
     </wwpage:Replacement>

     <!-- google-api-url -->
     <!--                -->
     <wwpage:Replacement name="google-api-url">
      <xsl:text>//www.google.com/jsapi</xsl:text>
      <xsl:if test="string-length(wwprojext:GetFormatSetting('google-api-key')) &gt; 0">
       <xsl:text>?key=</xsl:text>
       <xsl:value-of select="wwprojext:GetFormatSetting('google-api-key')" />
      </xsl:if>
     </wwpage:Replacement>

     <!-- Variables -->
     <!--           -->
     <xsl:variable name="VarVariablesAsXML">
      <xsl:call-template name="Variables-Filter-Last-Unique">
       <xsl:with-param name="ParamVariables" select="$ParamVariables" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarVariables" select="msxsl:node-set($VarVariablesAsXML)/wwvars:Variable" />
     <xsl:call-template name="Variables-Page-String-Replacements">
      <xsl:with-param name="ParamVariables" select="$VarVariables" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

    <!-- Map common characters -->
    <!--                       -->
    <wwexsldoc:MappingContext>
     <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

     <!-- Invoke page template -->
     <!--                      -->
     <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
      <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
      <xsl:with-param name="ParamOutputDirectoryPath" select="$VarOutputDirectoryPath" />
      <xsl:with-param name="ParamOutputPath" select="$ParamPath" />
      <xsl:with-param name="ParamConditions" select="$VarConditions" />
      <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
     </xsl:apply-templates>
    </wwexsldoc:MappingContext>
   </xsl:variable>

   <!-- Aborted? -->
   <!--          -->
   <xsl:if test="not(wwprogress:Abort())">
    <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
    <xsl:variable name="VarPrettyPrint">
     <xsl:choose>
      <xsl:when test="wwprojext:GetFormatSetting('file-processing-pretty-print') = 'true'">
       <xsl:text>yes</xsl:text>
      </xsl:when>

      <xsl:otherwise>
       <xsl:text>no</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:variable name="VarEncoding" select="wwprojext:GetFormatSetting('encoding', 'utf-8')" />
    <xsl:variable name="VarTempPath" select="wwfilesystem:GetTempFileName()" />
    <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarTempPath, $VarEncoding, 'html', '5.0', $VarPrettyPrint, 'yes', 'no', 'urn:WebWorks_DOCTYPE_ElementOnly', '')" />

    <!-- Configure script variables -->
    <!--                            -->
    <xsl:variable name="VarScriptReplacementsAsXML">
     <!-- Google Search ID -->
     <!--                  -->
     <xsl:variable name="VarGoogleSearchID" select="wwprojext:GetFormatSetting('google-search-id')" />
     <xsl:if test="string-length($VarGoogleSearchID) &gt; 0">
      <wwmultisere:Entry match="var searchID;" replacement="var searchID = '{$VarGoogleSearchID}';" />
     </xsl:if>

     <!-- Google AdSense -->
     <!--                -->
     <xsl:variable name="VarGoogleAdSenseID" select="wwprojext:GetFormatSetting('google-adsense-id')" />
     <xsl:if test="string-length($VarGoogleAdSenseID) &gt; 0">
      <wwmultisere:Entry match="//searchControl.enableAds('&lt;Your_AdSense_Publisher_ID&gt;');" replacement="searchControl.enableAds('{$VarGoogleAdSenseID}');" />
     </xsl:if>
    </xsl:variable>
    <xsl:variable name="VarScriptReplacements" select="msxsl:node-set($VarScriptReplacementsAsXML)/*" />
    <xsl:variable name="VarReplaceAllInFile" select="wwmultisere:ReplaceAllInFile($VarEncoding, $VarTempPath, $VarEncoding, $ParamPath, $VarScriptReplacements)" />
    <xsl:variable name="VarDeleteTempPath" select="wwfilesystem:DeleteFile($VarTempPath)" />
   </xsl:if>
  </xsl:if>

  <!-- Aborted? -->
  <!--          -->
  <xsl:if test="not(wwprogress:Abort())">
   <!-- Record files -->
   <!--              -->
   <wwfiles:File path="{$ParamPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($ParamPath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', $ParamPageTemplateFilesChecksum)}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalProjectVariablesPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectVariablesPath)}" groupID="" documentID="" />

    <!-- Page Template Include Files -->
    <!--                             -->
    <xsl:for-each select="$GlobalPageTemplateIncludeFiles">
     <xsl:variable name="VarFile" select="." />

     <wwfiles:Depends path="{$VarFile/@path}" checksum="{wwfilesystem:GetChecksum($VarFile/@path)}" groupID="" documentID="" />
    </xsl:for-each>
   </wwfiles:File>
  </xsl:if>

  <!-- Page Template Files -->
  <!--                     -->
  <xsl:for-each select="$ParamPageTemplateFiles/wwpage:File">
   <xsl:variable name="VarPageTemplateFile" select="." />

   <!-- Get source and destination paths -->
   <!--                                  -->
   <xsl:variable name="VarSourcePath" select="wwuri:AsFilePath(concat('wwformat:Pages/', $VarPageTemplateFile/@path))" />
   <xsl:variable name="VarDestinationPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, $VarPageTemplateFile/@path)" />
   
   <!-- Copy -->
   <!--      -->
   <xsl:variable name="VarPageTemplateFileUpToDate" select="wwfilesext:UpToDate($VarDestinationPath, '', '', '', concat($GlobalActionChecksum, ':', $VarSourcePath))" />
   <xsl:if test="not($VarPageTemplateFileUpToDate)">
    <xsl:variable name="VarIgnore" select="wwfilesystem:CopyFile($VarSourcePath, $VarDestinationPath)" />
   </xsl:if>

   <!-- Report Files -->
   <!--              -->
   <wwfiles:File path="{$VarDestinationPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarDestinationPath)}" projectchecksum="" groupID="" documentID="" actionchecksum="{concat($GlobalActionChecksum, ':', $VarSourcePath)}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$VarSourcePath}" checksum="{wwfilesystem:GetChecksum($VarSourcePath)}" groupID="" documentID="" />
   </wwfiles:File>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
